clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
file1 = 'C2_2025-05-05_12-25-47.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);

%% GRAFICI
%pitch
figure(1)

subplot(2,1,1)
plot(data1(:,1)-data1(1,1)-20,data1(:,16),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1)-20,data1(:,15)+2.5,"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('Velocity [feet/s]');
legend('com','response', 'Location', 'northeast');
xlim([0 100])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 400]) % [x, y, width, height]
ylim([790 910])

subplot(2,1,2)
plot(data1(:,1)-data1(1,1)-20,data1(:,23),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('throtte [%]');
xlim([0 100])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z

